<?php
require '../assets/config-data.php';

// Get and sanitize input
$kodehid = htmlspecialchars(mysqli_real_escape_string($data, $_POST['kodeak']));
$inbox = htmlspecialchars(mysqli_real_escape_string($data, $_POST['chatbox']));

// Insert statement using prepared statement
$isms = "INSERT INTO keluhan_member (kode_keluhan, receiver_keluhan, msg_keluhan, tgl_keluhan) VALUES (?, 'admin', ?, ?)";
$stmt1 = mysqli_prepare($data, $isms);
mysqli_stmt_bind_param($stmt1, "sss", $kodehid, $inbox, $today);
$qsms = mysqli_stmt_execute($stmt1);

// Update statement using prepared statement
$ubaca = "UPDATE keluhan_member SET baca_keluhan = '1' WHERE kode_keluhan = ? AND sender_keluhan != '' AND DATE(tgl_keluhan) < ?";
$stmt2 = mysqli_prepare($data, $ubaca);
mysqli_stmt_bind_param($stmt2, "ss", $kodehid, $today);
$qbaca = mysqli_stmt_execute($stmt2);

// Check for errors or success in each operation
if (!$qsms || !$qbaca) {
    echo 'Error in operations';
}

// Close statements and connection
mysqli_stmt_close($stmt1);
mysqli_stmt_close($stmt2);
mysqli_close($data);
